Attribute VB_Name = "MdlRipple"
Option Explicit

Type Ripple_t
    lngPoint As Integer     '' Point information
    dblFreq As Double       '' Frequency information
    sngLev As Single        '' Level information
End Type

Public RplMaxCnt As Integer
Public RplMinCnt As Integer
Public RplMax(0 To 800) As Ripple_t
Public RplMin(0 To 800) As Ripple_t

Private fbuf(0 To 1600) As Double   ''Internal local buffer
Private dbuf(0 To 1600) As Single   ''Internal local buffer

''----------------------------------------------------------------------------
''  Function name  FRplSearch
''  Function    FSearches for the maximum and minimum points (by specifying an array).
''  Argument    Flev As Single     Specifies the detection level
''            Freq() As Double  Frequency array
''            Data() As Single  Measured data array to be searched
''            Point As Long     Number of measurement points
''  Return value  FSuccessful (True) / Error (False)
''  Functional descriptionsFSearches the specified array variable for the maximum and minimum points and obtains the point, frequency, and level. (Searches for the maximum point first and then the minimum point.)
''            The result is stored in the variables below:
''              RplMaxCnt As IntegerFNumber of detected maximum points
''              RplMinCnt As IntegerFNumber of detected minimum points
''              RplMax() As Ripple_tFData array for maximum point (point, frequency, and level)
''              RplMin() As Ripple_tFData array for minimum point (point, frequency, and level)
''----------------------------------------------------------------------------
Function RplSearch(lev As Single, Freq() As Double, Data() As Single, Point As Long)
    Dim fl As Single, pk As Single
    Dim n As Integer
    Dim i As Integer
    Dim j As Integer
   
    RplSearch = False
    RplMaxCnt = 0: RplMinCnt = 0

    n = 0: pk = Data(n)
    For i = 1 To Point - 1
        If Data(i) > pk Then
            n = i: pk = Data(n)                     ''Storing peak value
        ElseIf Data(i) <= (pk - lev) Then           ''Judged as maximum
            RplMax(RplMaxCnt).lngPoint = n
            RplMax(RplMaxCnt).dblFreq = Freq(n)
            RplMax(RplMaxCnt).sngLev = Data(n)
            RplMaxCnt = RplMaxCnt + 1
            n = i: pk = Data(n)
            For j = i + 1 To Point - 1
                If Data(j) < pk Then
                    n = j: pk = Data(n)             ''Storing peak value
                ElseIf Data(j) >= (pk + lev) Then   ''Judged as minimum
                    RplMin(RplMinCnt).lngPoint = n
                    RplMin(RplMinCnt).dblFreq = Freq(n)
                    RplMin(RplMinCnt).sngLev = Data(n)
                    RplMinCnt = RplMinCnt + 1
                    n = j: pk = Data(n)
                    Exit For
                End If
            Next j
            i = j
        End If
    Next i
    
    If RplMaxCnt > 0 Then RplSearch = True

End Function

''----------------------------------------------------------------------------------
''  Function name  FRplSearchTR
''  Function    FSearches for the maximum and minimum points (by specifying analysis channel).
''  Argument    FlngPID As Long    Packet ID (specify the value obtained by BisOpenPacket)
''            lev As Single     Detection level
''            lngTr As Long     Analysis channels to be searched (trace number)
''  Return value  FSuccessful (True) / Error (False)
''  Functional descriptionsFAfter reading data from the specified analysis channel, searches for the maximum and minimum points and obtains the point, frequency, and level. (Searches for the maximum point first and then minimum point.)
''            The result is stored in the variables below:
''              RplMaxCnt As IntegerFNumber of detected maximum points
''              RplMinCnt As IntegerFNumber of detected minimum points
''              RplMax() As Ripple_tFData array for maximum point (point, frequency, and level)
''              RplMin() As Ripple_tFData array for minimum point (point, frequency, and level)
''  Note:FThe processing speed is slow because the frequency and measured data are read internally each time.
''----------------------------------------------------------------------------------
Function RplSearchTR(lngPID As Long, lev As Single, lngTr As Long)
    Dim pt As Long
    Dim Ch As Long
    
    RplSearchTR = False
    RplMaxCnt = 0: RplMinCnt = 0
    
    'Frequency table acquisition
    Ch = lngTr \ 1024 + 1
    If QrySourFreqTab(lngPID, Ch, fbuf(0)) <> 0 Then Exit Function
    ''Obtains the number of measurement points (-1) by specifying an extremely large frequency value.
    If QryFetcPoin(lngPID, Ch, CDbl(10000000000#), pt) <> 0 Then Exit Function
    'Measured data acquisition
    If QryTracData(lngPID, lngTr, 0, pt, dbuf(0)) <> 0 Then Exit Function
    
    RplSearchTR = RplSearch(lev, fbuf(), dbuf(), pt + 1)

End Function

